%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  lsrtags = "contemporary-notation, rhythms"

  texidoc = "
Beam nibs at the start and end of beams together with beams attached to
solitary notes that look like flat flags are possible with a
combination of @code{stemLeftBeamCount}, @code{stemRightBeamCount}, and
paired @code{[]} beam indicators.

For imitating right-pointing flat flags on lone notes, use paired
@code{[]} beam indicators and set @code{stemLeftBeamCount} to
zero.  For imitating left-pointing flat flags on lone notes, set
@code{stemRightBeamCount} to zero instead (line one).

For right-pointing nibs at the end of a run of beamed notes, set
@code{stemRightBeamCount} to a positive value.  For left-pointing nibs
at the start of a run of beamed notes, set @code{stemLeftBeamCount}
instead (line two).

Sometimes it may make sense for a lone note surrounded by rests to
carry both a left- and right-pointing nib.  Do this with paired
@code{[]} beam indicators alone (line three).

Note that @code{\\set stemLeftBeamCount} is always equivalent to
@code{\\once \\set}.  In other words, the beam count settings are not
@qq{sticky}, so the pair of nibs attached to the lone 16th note in the
last example has nothing to do with the @code{\\set} command for the
beam before.
"

  doctitle = "Beam nibs"
} % begin verbatim


\score {
  <<
    \new RhythmicStaff {
      \set stemLeftBeamCount = 0
      c16[] r8.
      r8.
      \set stemRightBeamCount = 0
      16[]
    }
    \new RhythmicStaff {
      16 16
      \set stemRightBeamCount = 2
      16 r r
      \set stemLeftBeamCount = 2
      16 16 16
    }
    \new RhythmicStaff {
      16 16
      \set stemRightBeamCount = 2
      16 r16
      16[] r16
      \set stemLeftBeamCount = 2
      16 16
    }
  >>
}
