%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Scheme, Simultaneous notes, Staff notation"

  texidoc = "
The @code{\\partCombine} function takes two music expressions, each
containing a part, and distributes them among four @code{Voice}
contexts named @qq{one}, @qq{two}, @qq{solo}, and @qq{shared}, depending on when
and how the parts are merged into a common voice.

Variants of @code{\\partCombine} are @code{\\partCombineUp} and
@code{\\partCombineDown} to produce up-stem and down-stem merging of
two voices, respectively. Combining them to squeeze four parts into a
single staff, however, need some special setup, which this snippet
defines accordingly.
"

  doctitle = "Two \\partCombine pairs on one staff"
} % begin verbatim


customPartCombineUp =
#(define-music-function (part1 part2) (ly:music? ly:music?)
  "Make an up-stem `VoiceBox` context that combines PART1 and PART2.

The context is called 'Up'; internally, the function calls
`\\partCombineUp`."
  #{
    \new VoiceBox = "Up" <<
      \context Voice = "one" { \voiceOne }
      \context Voice = "two" { \voiceThree }
      \context Voice = "shared" { \voiceOne }
      \context Voice = "solo" { \voiceOne }
      \context NullVoice = "null" {}
      \partCombine #part1 #part2
    >>
  #})

customPartCombineDown =
#(define-music-function (part3 part4) (ly:music? ly:music?)
  "Make a down-stem `VoiceBox` context that combines PART3 and PART4.

The context is called 'Down'; internally, the function calls
`\\partCombineDown`."
  #{
    \new VoiceBox = "Down" <<
      \set VoiceBox.soloText = #"Solo III"
      \set VoiceBox.soloIIText = #"Solo IV"
      \context Voice ="one" { \voiceFour }
      \context Voice ="two" { \voiceTwo }
      \context Voice ="shared" { \voiceFour }
      \context Voice ="solo" { \voiceFour }
      \context NullVoice = "null" {}
      \partCombine #part3 #part4
    >>
  #})

soprano = { d'4 | cis'  b  e'  d'8 cis' | cis'2 b }
alto = { fis4 | e8 fis gis ais b4 b | b ais fis2 }
tenor = { a8 b | cis' dis' e'4 b8 cis' d'4 | gis cis' dis'2 }
bass = { fis8 gis | a4 gis g fis | eis fis b,2 }

\new Staff <<
  \key b\minor
  \clef alto
  \partial 4
  \transpose b b' \customPartCombineUp \soprano \alto
  \customPartCombineDown \tenor \bass
>>

\layout {
  \context {
    \Staff
    \accepts "VoiceBox"
  }
  \context {
    \name "VoiceBox"
    \type "Engraver_group"
    \defaultchild "Voice"
    \accepts "Voice"
    \accepts "NullVoice"
  }
}
