%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Really cool, Scheme, Tweaks and overrides"

  texidoc = "
The @code{\\applyOutput} command allows the tuning of any layout
object, in any context. It requires a Scheme function with three
arguments.

In the example below, function @code{mc-squared} is executed for all
@code{NoteHead} grobs (within the current @code{Voice} context) at the
current time step; the function modifies the grob's @code{stencil},
using the @code{staff-position} property to replace some pitches with
markup.

See the
@uref{https://lilypond.org/doc/v2.24/Documentation/extending/running-a-function-on-all-layout-objects,@q{Extending}
manual} for more information.
"

  doctitle = "Changing properties for individual grobs"
} % begin verbatim


#(define (mc-squared grob grob-origin context)
   (let ((sp (ly:grob-property grob 'staff-position)))
     (ly:grob-set-property!
      grob 'stencil
      (grob-interpret-markup grob
       #{ \markup \lower #0.5
           #(case sp
              ((-5) "m")
              ((-3) "c ")
              ((-2) #{ \markup \teeny \bold 2 #})
              (else "bla")) #}))))

\relative c' {
  <d f g b>2
  \applyOutput Voice.NoteHead #mc-squared
  <d f g b>2
}
