%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Spacing, Tweaks and overrides, Workaround"

  texidoc = "
LilyPond uses @code{DynamicLineSpanner} grobs to horizontally align
successive dynamic objects like hairpins and dynamic text, even if they
are positioned on different sides of a staff. This connection cannot be
broken, contrary to the vertical alignment (see snippet @qq{Breaking
vertical alignment of dynamics and textscripts}).

There are two solutions to circumvent the problem.

@itemize
@item
Modify the @code{shorten-pair} property of the @code{Hairpin} grob to
compensate the offset by which the hairpin was moved.
@item
Put the two dynamic objects into different voices.
@end itemize

Both solutions are demonstrated in this snippet.
"

  doctitle = "Breaking horizontal alignment of dynamics and textscripts"
} % begin verbatim


{
  <>^"default"
  f'_\pp ^\> f' f' f'\!
}

{
  <>^\markup { setting \typewriter shorten-pair }
  f'_\pp \tweak shorten-pair #'(-3 . 0) ^\> f' f' f'\!
}

{
  <>^\markup { using another \typewriter Voice context }
  << { f'^\> f' f' f'\! }
     \new Voice { s4_\pp } >>
}

\layout {
  line-width = 8\cm
  ragged-right = ##f

  \context {
    \Voice
    \override TextScript.staff-padding = #3.5
  }
}
