%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Breaks, Contexts and engravers, Staff notation,
                Workaround"

  texidoc = "
When adding a new staff at a line break, some extra space is
unfortunately added at the end of the line before the break (to fit in
a key signature change, which is never printed anyway). The workaround
is to set the @code{explicitKeySignatureVisibility} property of the
@code{Staff} grob as is shown in the example.
"

  doctitle = "Adding an extra staff at a line break"
} % begin verbatim


\score {
  \new StaffGroup \relative c'' {
    \new Staff
    \key f \major
    c1 c^"Unwanted extra space" \break
    << { c1 | c }
       \new Staff {
         \key f \major
         \once \omit Staff.TimeSignature
         c1 | c
       }
    >>
    c1 | c^"Fixed here" \break
    << { c1 | c }
       \new Staff {
         \once \set Staff.explicitKeySignatureVisibility =
           #end-of-line-invisible
         \key f \major
         \once \omit Staff.TimeSignature
         c1 | c
       }
    >>
  }
}
