%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Staff notation, Tweaks and overrides"

  texidoc = "
To shape individual ties in chords use the method demonstrated below.
"

  doctitle = "Shape individual ties in chords"
} % begin verbatim


{
  \textMark "Chords can be tied note by note."
  <c'~ e'~ g'~ c''~>2 q
}

{
  \textMark \markup \override #'(baseline-skip . 3) \wordwrap {
    Modifying those ties with \typewriter "\\shape" does not succeed,
    because \typewriter TieColumn positions them on its own behalf,
    ignoring \typewriter "\\shape" input more or less.  You may
    circumvent this by setting \typewriter positioning-done to
    \typewriter "#t" – alas, \typewriter positioning-done is an
    internal property, and setting it to \typewriter "#t" means: all
    positioning is done, don’t do anything further.  The next example
    demonstrates a case where the positioning is not finished: all tie
    directions are down, and the thickness is not accurate.
  }
  <c'~ e'~ g'~ c''~>2
  \once \override TieColumn.positioning-done = ##t
  q
}

{
  \textMark "To fix that, enter ties with explicit direction modifiers."
  <c'_~ e'_~ g'_~ c''^~>2
  \once \override TieColumn.positioning-done = ##t
  q
}

{
  \textMark \markup {
    Now you can use \typewriter "\\shape" for each tie as usual. }
  <c'-\shape #'((0 . 0) (0 . -10) (0 . -10) (0 . 0)) _~
   e'-\shape #'((0 . 0) (0 . -5) (0 . -5) (0 . 0)) _~
   g'-\shape #'((0 . 0) (0 . -2) (0 . -2) (0 . 0)) _~
   c''-\shape #'((0 . 0) (0 . 5) (0 . 5) (0 . 0)) ^~
  >2
  \once \override TieColumn.positioning-done = ##t
  q
}

{
  \textMark "This also works at line breaks."
  <c'-\shape #'(((0 . 0) (0 . -10) (0 . -10) (0 . 0))
                ((0 . 0) (0 . -10) (0 . -10) (0 . 0))) _~
   e'-\shape #'(((0 . 0) (0 . -5) (0 . -5) (0 . 0))
                ((0 . 0) (0 . -5) (0 . -5) (0 . 0))) _~
   g'-\shape #'(((0 . 0) (0 . -2) (0 . -2) (0 . 0))
                ((0 . 0) (0 . -2) (0 . -2) (0 . 0))) _~
   c''-\shape #'(((0 . 0) (0 . 5) (0 . 5) (0 . 0))
                 ((0 . 0) (0 . 5) (0 . 5) (0 . 0))) ^~
  >2
  \break
  \once \override TieColumn.positioning-done = ##t
  q
}

{
  \textMark \markup {
    It also works with the \typewriter tieWaitForNote property. }
  \set tieWaitForNote = ##t
  c'4-\shape #'((0 . 0) (0 . -10) (0 . -10) (0 . 0)) _~
  e'-\shape #'((0 . 0) (0 . -5) (0 . -5) (0 . 0)) _~
  g'-\shape #'((0 . 0) (0 . -2) (0 . -2) (0 . 0)) _~
  c''-\shape #'((0 . 0) (0 . 5) (0 . 5) (0 . 0)) ^~
  \once \override TieColumn.positioning-done = ##t
  <c' e' g' c''>1
}

\layout {
  indent = 0
  \context {
    \Score
    \override TextMark.padding = #4
    \override TextMark.break-align-symbols = #'(left-edge)
  }
}

\paper {
  score-system-spacing.padding = 3
}
