%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Scheme, Tweaks and overrides"

  texidoc = "
Sometimes you may want to affect a single articulation type. Although
it is always possible to use @code{\\tweak}, it might become tedious to
do so for every single sign of a whole score. The following shows how
to tweak articulations with a list of custom settings. One use-case
might be to create a style sheet.
"

  doctitle = "Overriding articulations by type"
} % begin verbatim



#(define (custom-script-tweaks ls)
   (lambda (grob)
     (let* ((type (ly:event-property (ly:grob-property grob 'cause)
                                     'articulation-type))
           (tweaks (assoc-ref ls type)))
       (when tweaks
         (for-each
          (lambda (x) (ly:grob-set-property! grob (car x) (cdr x)))
          tweaks)))))

customScripts =
#(define-music-function (settings) (list?)
   #{
     \override Script.before-line-breaking =
       #(custom-script-tweaks settings)
   #})
revertCustomScripts = \revert Script.before-line-breaking


% Example

% Predefine two sets of desired tweaks.
#(define my-settings-1
   '((accent . ((font-size . 0)
                (color . (1 0 0))))
     (segno . ((font-size . 0)
               (color . (1 0 0))))
     (staccato . ((color . (1 0 0))
                  (padding . 0.5)))
     (staccatissimo . ((padding . 1)
                       (color . (1 0 0))))
     (tenuto . ((color . (1 0 0))
                (rotation . (45 0 0))
                (padding . 2)
                (font-size . 10)))
    ))

#(define my-settings-2
  '((accent . ((font-size . 4)
               (color . (0 1 0))
               (padding . 1.5)))
    (coda . ((color . (0 1 0))
             (padding . 1)))
    (staccato . ((color . (0 1 0))))
    (staccatissimo . ((padding . 2)
                      (color . (0 1 0))))
    (tenuto . ((color . (0 1 0))
               (font-size . 10)))
    ))

music = { f1-> | f\segno | f-. | f-! | f-- | f--\coda | f-!\fermata | }

block = {
  \music
  \break
  \revertCustomScripts \music
}

\new Staff <<
  \new Voice \with { \customScripts #my-settings-1 }
    \relative c''{ \voiceOne \block }
  \new Voice \with { \customScripts #my-settings-2 }
    \relative c' { \voiceTwo \block }
>>
