%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Chords, Fretted strings, Specific notation"

  texidoc = "
Sometimes chords with a stretched fingering are required. If not
otherwise specified the context property @code{maximumFretStretch} is
set to value@tie{}4, though, resulting in a warning about @qq{No string
for pitch ...}, and the note is omitted. You may set
@code{maximumFretStretch} to an approppriate value or explicitly assign
string numbers to all notes of a chord to fix that.
"

  doctitle = "Chords with stretched fingering for FretBoards and TabVoice"
} % begin verbatim


% The code below prints two warnings for the second chord,
% which may be omitted by uncommenting the following line.
%
% #(for-each (lambda (x) (ly:expect-warning "No string for pitch")) (iota 2))

mus = {
  <c' bes'>
  <c'\2 bes'>
  \set maximumFretStretch = 5
  <c' bes'>
  <c'\2 bes'\1>
}

<<
  \new FretBoards \mus
  \new TabVoice \mus
>>
