%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Scheme"

  texidoc = "
You can add additional elements to notes using @code{map-some-music}.
In this example, an extra script is attached to a note (or a chord).

In general, you should first apply @code{\\displayMusic} to music
similar to what you want to create so that you can see its structure.
This can be then used as template for your Scheme code.
"

  doctitle = "Adding extra fingering with Scheme"
} % begin verbatim


addScript =
#(define-music-function (script music) (ly:event? ly:music?)
   (map-some-music
    (lambda (mus)
      (define (append-script-at! prop)
        (set! (ly:music-property mus prop)
              (append (ly:music-property mus prop)
                      (list (ly:music-deep-copy script))))
        mus)

      (case (ly:music-property mus 'name)
        ((EventChord)
         (append-script-at! 'elements))
        ((NoteEvent)
         (append-script-at! 'articulations))
        (else #f)))
    music))

{
  \addScript _6 { c'4-3 <c' e' g'> }
}
