%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Correction wanted, Spacing, Staff notation"

  texidoc = "
A regularly occurring problem in ensemble or chamber music scores,
particularly with piano, is that when some of the staves are printed in
a smaller size, their bar lines do not not match those of larger
staves. This may become particularly egregious for closing double bar
lines, as demonstrated here.

There are different solutions, which all involve correcting some of the
properties overridden by the @code{\\magnifyStaff} command: namely,
@code{kern} @code{thick-thickness} and @code{hair-thickness} (the
latter of which also governs ordinary bar lines). These are properties
of the @code{BarLine} graphical object (@qq{@emph{grob}}), which resides
in the @code{Staff} context.

This can be done by using either the @code{\\revert} command, or more
advanced commands such as @code{revert-props}. Alternatively, some
effects of @code{\\magnifyStaff} may be replicated on other staves
through the @code{scale-props} command, which may be used to harmonize
all bar lines either to their appearance on the smallest staves, or to
some intermediate value.
"

  doctitle = "Reconciliating bar lines thickness when staves are of different sizes (TODO duplicates snippet in Documentation/en/notation/spacing.itely)"
} % begin verbatim


%% This snippet relies on some internal commands that are not part of the
%% most common and stable syntax generally recommended to regular users.

\markup \fontsize #-3 {
  \center-column {
    \vspace #0.3
    Default:
    \vspace #1.7
    \score {
      \new StaffGroup <<
        \new Staff \with {
          \magnifyStaff #1/2
        } { b1 b \bar "|."}
        \new Staff { b b }
      >>
    }
  }
  \hspace #2
  \center-column {
    "Reverting only the"
    "final bar line:"
    \vspace #1.2
    \score {
      \new StaffGroup <<
        \new Staff \with {
          \magnifyStaff #1/2
        } {
          b1 b
          \revert Staff.BarLine.thick-thickness
          \revert Staff.BarLine.hair-thickness
          \revert Staff.BarLine.kern
          \bar "|."
        }
        \new Staff { b b }
      >>
    }
  }
  \hspace #2
  \center-column {
    \line {Cancelling \typewriter "\magnifyStaff"}
    "only for bar lines:"
    \vspace #1.1
    \score {
      \new StaffGroup <<
        \new Staff \with {
          \magnifyStaff #1/2
          #(revert-props 'magnifyStaff 0
                         '((BarLine thick-thickness)
                           (BarLine hair-thickness)
                           (BarLine kern)))
        } { b1 b \bar "|."}
        \new Staff { b b }
      >>
    }
  }
  \hspace #2
  \center-column {
    \line {Mimicking \typewriter "\magnifyStaff"}
    "on the other staves:"
    \vspace #1.3
    \score {
      \new StaffGroup <<
        \new Staff \with {
          \magnifyStaff #1/2
        } { b1 b \bar "|." }
        \new Staff \with {
          #(scale-props 'magnifyStaff 1/2 #t
                        '((BarLine thick-thickness)
                          (BarLine hair-thickness)
                          (BarLine kern)))
        } { b b }
      >>
    }
  }
  \hspace #2
  \center-column {
    "Applying an intermediate"
    "value to all staves:"
    \vspace #1.3
    \score {
      \new StaffGroup <<
        \new Staff \with {
          \magnifyStaff #1/2
          #(scale-props 'magnifyStaff 3/2 #t
                        '((BarLine thick-thickness)
                          (BarLine hair-thickness)
                          (BarLine kern)))
        } { b1 b \bar "|." }
        \new Staff \with {
          #(scale-props 'magnifyStaff 3/4 #t
                        '((BarLine thick-thickness)
                          (BarLine hair-thickness)
                          (BarLine kern)))
        } { b b }
      >>
    }
  }
}
\layout { indent = 0 }
