%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Expressive marks, Rhythms"

  texidoc = "
Slurs can be composed of complex dash patterns by setting the
@code{dash-definition} property, which is a list of slur segments,
which in turn are lists of parameters setting up the dash behavior of
the given segment.

Slur segments are defined in terms of the Bézier
parameter@tie{}@var{t}, which ranges from@tie{}0 at the left end
of the slur to@tie{}1 at the right end of the slur. A slur segment has
the form
@code{(@var{start-t} @var{stop-t} @var{dash-fraction} @var{dash-period})}.
In the segment spanning the range @var{start-t} to
@var{stop-t}, the dash pattern is defined by the values of
@var{dash-fraction} and @var{dash-period}.
@var{dash-fraction} specifies how much of a dash period is black;
if set to@tie{}1 you get a solid slur segment. The unit for
@var{dash-period} is staff spaces.
"

  doctitle = "Making slurs with complex dash structure"
} % begin verbatim


\relative c' {
  \once \override
    Slur.dash-definition = #'((  0  0.3  0.1 0.75)
                              (0.3  0.6  1   1   )
                              (0.65 1.0  0.4 0.75))
  c4( d e f)
  \once \override
    Slur.dash-definition = #'((0    0.25  1   1   )
                              (0.3  0.7   0.4 0.75)
                              (0.75 1.0   1   1   ))
  c4( d e f)
}
