%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Editorial annotations, Scheme, Tweaks and overrides"

  texidoc = "
When a note head with a special shape cannot easily be generated with
graphic markup, a drawing specification for @code{ly:make-stencil} can
be used to generate the shape. This example gives an example for a
parallelogram-shaped note head.

Unfortunately, the available commands in a drawing specification are
@uref{https://gitlab.com/lilypond/lilypond/-/issues/6874,currently not
documented}; in any case, the used @code{path} sub-command has the
following signature, quite similar to the @code{make-path-stencil}
Scheme function.

@example
(path @var{thickness} @var{command-list} @var{line-cap-style} @var{line-join-style} @var{fill})
@end example

The commands in @var{command-list} resemble PostScript drawing
commands but with arguments after the command name.
"

  doctitle = "Generate special note head shapes"
} % begin verbatim


parallelogram =
  #(ly:make-stencil
    '(path 0.1
           (rmoveto 0 0.25
            lineto 1.2 0.75
            lineto 1.2 -0.25
            lineto 0 -0.75
            lineto 0 0.25)
           round
           round
           #t)
    (cons -0.05 1.25)
    (cons -.75 .75))

myNoteHeads = \override NoteHead.stencil = \parallelogram
normalNoteHeads = \revert NoteHead.stencil

\relative c'' {
  \myNoteHeads
  g4 d'
  \normalNoteHeads
  <f, \tweak stencil \parallelogram b e>4 d
}
