%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Repeats, Workaround"

  texidoc = "
Currently, @code{@var{note}:@var{duration}}, which is more or
less a shortcut for @code{\\repeat tremolo}, is not unfolded by
@code{\\unfoldRepeats} (this is tracked in
@uref{https://gitlab.com/lilypond/lilypond/-/issues/6145,Issue #6145}).
The function given in this snippet provides a workaround.
"

  doctitle = "Unfolding tremolo repeats"
} % begin verbatim


fixTremolos =
#(define-music-function (music) (ly:music?)
   (music-map
    (lambda (m)
      (let ((event (any (lambda (a)
                          (and (music-is-of-type? a 'tremolo-event)
                               a))
                        (ly:music-property m 'articulations))))
        (if event
            (let* ((total-tremolo-duration (ly:music-property m
                                                              'duration))
                   (tremolo-type (ly:music-property event
                                                    'tremolo-type))
                   (one-tremolo-note-duration
                    (ly:make-duration (ly:intlog2 tremolo-type)))
                   (tremolo-note-count
                    (/ tremolo-type (expt 2 (ly:duration-log
                                             total-tremolo-duration)))))
              (set! (ly:music-property m 'duration)
                    one-tremolo-note-duration)
              (set! (ly:music-property m 'articulations)
                    (delete! event (ly:music-property m 'articulations)))
              (make-music 'TremoloRepeatedMusic
                          'repeat-count tremolo-note-count
                          'element m))
            m)))
    music))

unfoldRepeats = \unfoldRepeats #'() \fixTremolos \etc

music = { \repeat tremolo 8 c'16 c'2:16 }

{
  \music
  \unfoldRepeats \music
}
