%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Spacing, Staff notation"

  texidoc = "
When using @code{\\magnifyStaff} only for some staves in a
@code{StaffGroup}, @code{BarLine} grobs do not align any more due to
its changed properties @code{thick-thickness}, @code{hair-thickness},
and @code{kern}.

To fix this, multiple workarounds are available, as demonstrated below.
"

  doctitle = "Harmonizing bar line thickness for staves with different sizes"
} % begin verbatim



\markuplist {
  % First row.
  \fill-line {
    \score {
      \new StaffGroup <<
        \new Staff \with { \magnifyStaff #1/2 } {
          \textMark \markup \tiny "default"
          b1 b \bar "|."
        }
        \new Staff { b b }
      >>
    }
    \score {
      \new StaffGroup <<
        \new Staff \with { \magnifyStaff #1/2 } {
          \textMark \markup \tiny \column { "reverting only the"
                                            "final bar line" }
          b1 b
          \revert Staff.BarLine.thick-thickness
          \revert Staff.BarLine.hair-thickness
          \revert Staff.BarLine.kern
          \bar "|."
        }
        \new Staff { b b }
      >>
    }
    \score {
      \new StaffGroup <<
        \new Staff \with { \magnifyStaff #1/2
                           #(revert-props 'magnifyStaff 0
                                          '((BarLine thick-thickness)
                                            (BarLine hair-thickness)
                                            (BarLine kern))) } {
          \textMark \markup \tiny \column { "cancelling"
                                            \typewriter "\magnifyStaff"
                                            "only for bar lines" }
          b1 b \bar "|."
        }
        \new Staff { b b }
      >>
    }
  }

  \vspace #2

  % Second row.
  \fill-line {
    \score {
      \new StaffGroup <<
        \new Staff \with { \magnifyStaff #1/2 } {
          \textMark \markup \tiny \column { "mimicking"
                                            \typewriter "\magnifyStaff"
                                            "on the other staves" }
          b1 b \bar "|." }
        \new Staff \with { #(scale-props 'magnifyStaff 1/2 #t
                                         '((BarLine thick-thickness)
                                           (BarLine hair-thickness)
                                           (BarLine kern))) } {
          b b }
      >>
    }
    \score {
      \new StaffGroup <<
        \new Staff \with { \magnifyStaff #1/2
                           #(scale-props 'magnifyStaff 3/2 #t
                                         '((BarLine thick-thickness)
                                           (BarLine hair-thickness)
                                           (BarLine kern))) } {
          \textMark \markup \tiny \column { "applying an"
                                            "intermediate"
                                            "value to all staves" }
          b1 b \bar "|." }
        \new Staff \with { #(scale-props 'magnifyStaff 3/4 #t
                                         '((BarLine thick-thickness)
                                           (BarLine hair-thickness)
                                           (BarLine kern))) } {
           b b }
      >>
    }
    ""
  }
}
