%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Editorial annotations, Scheme"

  texidoc = "
Choose different font sizes for @code{instrumentName} and
@code{shortInstrumentName} as a context override.
"

  doctitle = "Different font size settings for instrumentName and shortInstrumentName"
} % begin verbatim


InstrumentNameFontSize =
#(define-music-function (font-size-pair) (pair?)
   "Set the font size of `InstrumentName` grobs.

The first value of FONT-SIZE-PAIR sets the font size of the initial
`instrumentName` property, the second value sets the font size of
`shortInstrumentName`."
   ;; This code could be changed or extended to set different values
   ;; for each occurrence of `shortInstrumentName'.
   #{
     \override InstrumentName.after-line-breaking =
       #(lambda (grob)
          (let* ((orig (ly:grob-original grob))
                 (siblings (if (ly:grob? orig)
                               (ly:spanner-broken-into orig)
                               '())))
            (when (pair? siblings)
              (ly:grob-set-property! (car siblings)
                                     'font-size (car font-size-pair))
              (for-each
               (lambda (g)
                 (ly:grob-set-property! g
                                        'font-size (cdr font-size-pair)))
               (cdr siblings)))))
   #})

\layout {
  indent = 3\cm
  short-indent = 0.8\cm

  \context {
    \Staff
    \InstrumentNameFontSize #'(6 . -3)
  }
}

\new StaffGroup <<
  \new Staff \with {
       instrumentName = "Flute"
       shortInstrumentName = "Fl." } {
    c''1 \break c'' \break c'' }
  \new Staff \with {
       instrumentName = "Violin"
       shortInstrumentName = "Vl." } {
    c''1 \break c'' \break c'' }
>>
