%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Simultaneous notes, Syntax and expressions, Text"

  texidoc = "
The part combiner tool (i.e., the @code{\\partCombine} command) allows
the combination of several different parts on the same staff. Text
directions such as @qq{solo} or @qq{a2} are added by default; to remove them,
simply set the property @code{printPartCombineTexts} to @code{#f}.

For vocal scores (hymns), there is no need to add @qq{solo/a2} texts, so
they should be switched off. However, it might be better not to use
them if there are any solos, as they won't be indicated. In such cases,
standard polyphonic notation may be preferable.

This snippet presents the three ways two parts can be printed on a same
staff: standard polyphony, @code{\\partCombine} without texts, and
@code{\\partCombine} with texts.
"

  doctitle = "Combining two parts on the same staff"
} % begin verbatim


musicUp = \relative c'' {
  \time 4/4
  a4 c4.( g8) a4 |
  g4 e' g,( a8 b) |
  c b a2.
}

musicDown = \relative c'' {
  g4 e4.( d8) c4 |
  r2 g'4( f8 e) |
  d2 \stemDown a
}

\score {
  <<
    \new Staff \with {
      instrumentName = "standard polyphony"
    } << \musicUp \\ \musicDown >>

    \new Staff \with {
      instrumentName =
        \markup { \typewriter "\\partCombine" without text}
      printPartCombineTexts = ##f
    } \partCombine \musicUp \musicDown

    \new Staff \with {
      instrumentName =
        \markup { \typewriter "\\partCombine" with text}
    } \partCombine \musicUp \musicDown
  >>

  \layout {
    indent = 6.0\cm
    \context {
      \Score
      % Setting this to a large value avoids a bar line at the
      % beginning that would connect the three staves otherwise.
      \override SystemStartBar.collapse-height = 30
    }
  }
}
