%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Contemporary notation, Editorial annotations, Vocal
                music, Workaround"

  texidoc = "
This example shows how to put crosses on stems. Mark the beginning of a
spoken section with the command @code{\\speakOn} and end it with
@code{\\speakOff}.
"

  doctitle = "Marking notes of spoken parts with a cross on the stem (Sprechstimme)"
} % begin verbatim


speakOn = \override Stem.stencil =
  #(lambda (grob)
     (let* ((x-parent (ly:grob-parent grob X))
            (is-rest? (ly:grob? (ly:grob-object x-parent 'rest))))
       (if is-rest?
           empty-stencil
           (ly:stencil-combine-at-edge
            (ly:stem::print grob)
            Y
            (- (ly:grob-property grob 'direction))
            (grob-interpret-markup
	     grob
             (markup #:center-align #:fontsize -4
                     #:musicglyph "noteheads.s2cross"))
            -1.7))))

speakOff = \revert Stem.stencil

\new Staff {
  \relative c'' {
    a4 b a c
    \speakOn
    g4 f r g8 a
    b4 r r8 d e4
    \speakOff
    c4 a g f
  }
}
