%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Contemporary notation, Pitches, Really cool, Staff
                notation, Version-specific"

  texidoc = "
The commonly used @code{\\key} command sets the @code{keyAlterations}
property, in the @code{Staff} context.

To create non-standard key signatures, set this property directly. The
format of this command is a list:

@example
\\set Staff.keyAlterations =
  #`(((@var{octave . @var{step}) . @var{alter}) ((@var{octave} . @var{step}) . @var{alter}) ...)}
@end example

where, for each element in the list, @var{octave} specifies the
octave (0@tie{}being the octave from middle@tie{}C to the B above),
@var{step} specifies the note within the octave
(0@tie{}means@tie{}C and 6@tie{}means@tie{}B), and @var{alter} is
one of @code{SHARP}, @code{FLAT}, @code{DOUBLE-SHARP}, etc., preceded
by a comma.

Alternatively, you can use the more concise format
@code{(@var{step} . @var{alter})} for each item in the list
if the same alterations are used in all octaves.

For microtonal scales where a @qq{sharp} is not 100 cents,
@var{alter} refers to the alteration as a proportion of a 200-cent
whole tone.
"

  doctitle = "Non-traditional key signatures"
} % begin verbatim


\include "arabic.ly"

\relative do' {
  \set Staff.keyAlterations = #`((0 . ,SEMI-FLAT)
                                 (1 . ,SEMI-FLAT)
                                 (2 . ,FLAT)
                                 (5 . ,FLAT)
                                 (6 . ,SEMI-FLAT))
  % \set Staff.extraNatural = ##f
  re reb \dwn reb resd
  dod dob dosd \dwn dob |
  dobsb dodsd do do |
}
