%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Wiki
%% (https://wiki.lilypond.community).
%%
%% Make any changes in the Wiki itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.24.0"

\header {
  categories = "Repeats, Tweaks and overrides"

  texidoc = "
Using various properties of the @code{StemTremolo} grob it is possible
to control the appearance of tremolo slashes.

@itemize
@item
Property @code{slope} sets the slope for tremolo slashes.
@item
Property @code{shape} determines whether tremolo slashes look like
rectangles (value @code{rectangle}) or like very small beams (value
@code{beam-like}).
@item
Property @code{style} sets both the slope and the shape depending on
whether the note has flags, beams, or only a plain stem. This is in
contrast to the previous two properties, which change the slope and
shape unconditionally. There are two styles defined.
@itemize
@item
@code{default}: slashes for down-stem flags are longer and more sloped
than slashes for up-stem flags; slashes on beamed notes have a
rectangular shape and are parallel to the beam.
@item
@code{constant}: all slashes are beam-like and have the same slope
except for down-stem flags.
@end itemize

@end itemize
"

  doctitle = "Controlling the appearance of tremolo slashes"
} % begin verbatim


music = {
  a''4:32 a':
  e''8: \noBeam e':
  a'':[ a':]
  f':[ g':]
  d':[ d':]
}

\new Staff {
  <>^\markup "default"
  \music
}

\new Staff {
  <>^\markup \typewriter "style = #'constant"
  \override StemTremolo.style = #'constant
  \music
}

\new Staff {
  <>^\markup \typewriter "shape = #'rectangle"
  \override StemTremolo.shape = #'rectangle
  \music
}

\new Staff {
  <>^\markup \typewriter "shape = #'beam-like"
  \override StemTremolo.shape = #'beam-like
  \music
}

\new Staff {
  <>^\markup \typewriter "slope = -0.2"
  \override StemTremolo.slope = -0.2
  \music
}

\paper {
  indent = 0
  tagline = ##f
}
